/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.giantRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.RewardsUtil;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ChunkReverserReward
extends BaseCustomReward {
    private final List<Map.Entry<Block, Block>> swappedMap = new ArrayList<Map.Entry<Block, Block>>();

    public ChunkReverserReward() {
        super("chancecubes:chuck_reverse", 0);
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_50493_, Blocks.f_50652_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_50069_, Blocks.f_50493_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_50440_, Blocks.f_50069_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_49994_, Blocks.f_49992_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_49992_, Blocks.f_49994_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_49996_, Blocks.f_49995_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_49997_, Blocks.f_50089_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_50089_, Blocks.f_49997_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_49995_, Blocks.f_49996_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_49991_, Blocks.f_49990_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_49990_, Blocks.f_49991_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_50003_, Blocks.f_50054_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_50054_, Blocks.f_50003_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_50004_, Blocks.f_50055_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_50055_, Blocks.f_50004_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_49999_, Blocks.f_50050_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_50050_, Blocks.f_49999_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_50001_, Blocks.f_50052_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_50052_, Blocks.f_50001_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_50002_, Blocks.f_50053_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_50053_, Blocks.f_50002_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_50000_, Blocks.f_50051_));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.f_50051_, Blocks.f_50000_));
    }

    @Override
    public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
        RewardsUtil.sendMessageToPlayer(player, "Initiating Block Inverter");
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        int delay = 0;
        for (int yy = 256; yy > 0; --yy) {
            int xx = 0;
            int zz = 0;
            int dx = 0;
            int dy = -1;
            int t = 16;
            int maxI = t * t;
            for (int i = 0; i < maxI; ++i) {
                if (-8 <= xx && xx <= 8 && -8 <= zz && zz <= 8) {
                    Block blockAt = level.m_8055_(new BlockPos(pos.m_123341_() + xx, yy, pos.m_123343_() + zz)).m_60734_();
                    Block toSwapTo = null;
                    for (Map.Entry<Block, Block> blockSwap : this.swappedMap) {
                        if (!blockSwap.getKey().equals(blockAt)) continue;
                        toSwapTo = blockSwap.getValue();
                    }
                    if (toSwapTo != null) {
                        blocks.add(new OffsetBlock(xx, yy - pos.m_123342_(), zz, toSwapTo, false, delay / 5));
                        ++delay;
                    }
                }
                if (xx == zz || xx < 0 && xx == -zz || xx > 0 && xx == 1 - zz) {
                    t = dx;
                    dx = -dy;
                    dy = t;
                }
                xx += dx;
                zz += dy;
            }
        }
        RewardsUtil.sendMessageToPlayer(player, "Inverting " + blocks.size() + " Blocks... May take a minute...");
        for (OffsetBlock b : blocks) {
            b.spawnInWorld((Level)level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
    }
}

